var adDiv;
var pie, vegetables, pasta;
var descRange, descOven, descCooktop;
var expandBtn, closeBtn, expCtaBtn;
var clicked = "range";

function initEB() {
    if (!EB.isInitialized()) {
        EB.addEventListener(EBG.EventName.EB_INITIALIZED, startAd);
    } else {
        startAd();
    }
}

function startAd() {
    adDiv = document.getElementById("ad");

    container = document.getElementById('container_dc');
    nav = document.getElementById('nav');
    pie = document.getElementById('pie');
    vegetables = document.getElementById('vegetables');
    pasta = document.getElementById('pasta');
    range = document.getElementById('range')
    oven = document.getElementById('oven')
    cooktop = document.getElementById('cooktop')
    descRange = document.getElementById('descRange');
    descOven = document.getElementById('descOven');
    descCooktop = document.getElementById('descCooktop');
    expandBtn = document.getElementById('expandBtn');
    closeBtn = document.getElementById('closeBtn');
    expCtaBtn = document.getElementById('expCtaBtn');
    ctaOff = document.getElementById('ctaOff');
    ctaOver = document.getElementById('ctaOver');
    
    expCtaOff = document.getElementById('expCtaOff');
    expCtaOver = document.getElementById('expCtaOver');    
    
    blueberries = document.getElementById('blueberries');
    muffins = document.getElementById('muffins');
    endFrame = document.getElementById('endFrame');
      
    aniGo();
    useInAppCloseButton();
    addEventListeners();
}

function useInAppCloseButton() {
    var sdkData = EB.getSDKData();

    if (sdkData !== null) {
        if (sdkData.SDKType === "MRAID") {
            // set sdk to use custom close button
            EB.setExpandProperties({
                useCustomClose: true
            });
        }
    }
}


function aniGo(){
    TweenLite.to(blueberries, 2, {delay:2, alpha:0});
    TweenLite.to(muffins, 2, {delay:5, alpha:0, onComplete:addEventListeners});
}

function addEventListeners() {
    expandBtn.addEventListener('click', expand, false);
    expandBtn.addEventListener('mouseover', ctaIn, false);
    expandBtn.addEventListener('mouseout', ctaOut, false);    
    
    closeBtn.addEventListener('click', collapse, false);
    expCtaBtn.addEventListener('click', clickthrough, false);
    expCtaBtn.addEventListener('mouseover', ctaIn, false);
    expCtaBtn.addEventListener('mouseout', ctaOut, false);     
    

    
//    range.addEventListener('mouseover', mouseIn, false);
    oven.addEventListener('mouseover', mouseIn, false);
    cooktop.addEventListener('mouseover', mouseIn, false);
    
//    range.addEventListener('mouseout', mouseLeave, false);
    oven.addEventListener('mouseout', mouseLeave, false);
    cooktop.addEventListener('mouseout', mouseLeave, false);
    
    range.addEventListener('click', toggleNav, false);
    oven.addEventListener('click', toggleNav, false);
    cooktop.addEventListener('click', toggleNav, false);
}

function expand() {
    EB.expand();
    adDiv.classList.remove("collapsed");
    adDiv.classList.add("expanded");
    addEventListeners();
}

function collapse() {
    adDiv.classList.remove("expanded");
    adDiv.classList.add("collapsed");
    EB.collapse();
}

function clickthrough() {
    EB.clickthrough();
}

function userActionCounter() {
    EB.userActionCounter("CustomInteraction");
}

//function showExpandedAssets(){
//    EB.expand();
//    expanded_content.style.display = "block";
//    content.style.display = "none";
//}
//
//function closeAssets(){
//    EB.collapse();
//    expanded_content.style.display = "none";
//    content.style.display = "block";
//}


function ctaIn(){
    ctaOff.style.display = "none";
    ctaOver.style.display = "block";
    
    expCtaOff.style.display = "none";
    expCtaOver.style.display = "block";      
}

function ctaOut(){
    ctaOff.style.display = "block";
    ctaOver.style.display = "none"; 
    
    expCtaOff.style.display = "block";
    expCtaOver.style.display = "none";        
}

function mouseIn(e){

    switch(e.target){
            
    case range:
     rangeOn.style.display = "block";
     rangeOff.style.display = "none";
    break;
            
    case oven:
     ovenOn.style.display = "block";
     ovenOff.style.display = "none";
    break;
            
    case cooktop:
     cooktopOn.style.display = "block";
     cooktopOff.style.display = "none";
    break;        
    }
    
}

function mouseLeave(e){

    switch(e.target){
            
    case range:
     rangeOff.style.display = "block";
     rangeOn.style.display = "none";
            
    break;
            
    case oven:
     ovenOff.style.display = "block";
     ovenOn.style.display = "none";
            
    break;
            
    case cooktop:
     cooktopOff.style.display = "block";
     cooktopOn.style.display = "none";
            
    break;        
    }
    
}


function toggleNav(e){
    deactivateNav(clicked);
    
    
    switch(clicked){        
    case range:
    rangeOn.style.display = "block";
    rangeOff.style.display = "none";
    break;
            
    case oven:
    ovenOn.style.display = "block";
    ovenOff.style.display = "none";
    
    break;
            
    case cooktop:
    cooktopOn.style.display = "block";
    cooktopOff.style.display = "none";
    break;        
    }
    
    clicked = e.target.id;
    activateNav(clicked);
       
}


function activateNav(e){
    switch(e){  
    case "range":
            pie.style.display = "block";
            vegetables.style.display = "none";
            pasta.style.display = "none";         
            descRange.style.display = "block";
            descOven.style.display = "none";
            descCooktop.style.display = "none";
            range.removeEventListener('click', toggleNav, false);
            range.removeEventListener('mouseout', mouseLeave, false);
            range.removeEventListener('mouseover', mouseIn, false);
    break;
            
    case "oven":
            pie.style.display = "none";
            vegetables.style.display = "block";
            pasta.style.display = "none";
            descRange.style.display = "none";
            descOven.style.display = "block";
            descCooktop.style.display = "none";
            oven.removeEventListener('click', toggleNav, false);
            oven.removeEventListener('mouseout', mouseLeave, false);
            oven.removeEventListener('mouseover', mouseIn, false); 
    break;
            

    case "cooktop":
            pie.style.display = "none";
            vegetables.style.display = "none";            
            pasta.style.display = "block";            
            descRange.style.display = "none";
            descOven.style.display = "none";            
            descCooktop.style.display = "block";
            cooktop.removeEventListener('click', toggleNav, false);   
            cooktop.removeEventListener('mouseout', mouseLeave, false);
            cooktop.removeEventListener('mouseover', mouseIn, false);
    break;        
    }
}

function deactivateNav(e){
    
    switch(e){  
    case "range":
            rangeOff.style.display = "block";
            rangeOn.style.display = "none";
            range.addEventListener('click', toggleNav, false);
            range.addEventListener('mouseout', mouseLeave, false);
            range.addEventListener('mouseover', mouseIn, false);
    break;
            
    case "oven":
            ovenOff.style.display = "block";
            ovenOn.style.display = "none";
            oven.addEventListener('click', toggleNav, false);
            oven.addEventListener('mouseout', mouseLeave, false);
            oven.addEventListener('mouseover', mouseIn, false); 
    break;
            
    case "cooktop":
            cooktopOff.style.display = "block";
            cooktopOn.style.display = "none";
            cooktop.addEventListener('click', toggleNav, false);   
            cooktop.addEventListener('mouseout', mouseLeave, false);
            cooktop.addEventListener('mouseover', mouseIn, false);
    break;        
    }
}

window.addEventListener("load", initEB);
